/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import java.util.ArrayList;
import java.util.List;
import net.hibiscus.naturespirit.blocks.LargeFlowerBlock;
import net.hibiscus.naturespirit.blocks.MidFlowerBlock;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2498;
import net.minecraft.class_2521;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class FlowerSet {
    private final String name;
    private final class_1792 dyeColor;
    private final class_1291 statusEffect;
    private final class_1792 itemBefore;
    private final FlowerPreset preset;
    private class_2248 flowerBlock;
    private class_2248 pottedFlowerBlock;
    private final List<class_2248> registeredBlocksList = new ArrayList<class_2248>();
    private final List<class_1792> registeredItemsList = new ArrayList<class_1792>();

    public FlowerSet(String name, class_1792 dyeColor, class_1291 statusEffect, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = statusEffect;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1792 dyeColor, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = dyeColor;
        this.statusEffect = null;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1291 statusEffect, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = statusEffect;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    public FlowerSet(String name, class_1792 itemBefore, FlowerPreset preset) {
        this.name = name;
        this.dyeColor = null;
        this.statusEffect = null;
        this.itemBefore = itemBefore;
        this.preset = preset;
        this.registerFlower();
    }

    private void registerFlower() {
        if (this.isTall()) {
            this.flowerBlock = NSRegistryHelper.registerTallPlantBlock(this.name, (class_2248)new class_2521(class_4970.class_2251.method_9637().method_9634().method_9618().method_9626(class_2498.field_11535).method_50013().method_49229(class_4970.class_2250.field_10657).method_50012(class_3619.field_15971)), (class_1935)this.itemBefore, 0.4f);
        } else if (this.preset == FlowerPreset.BIG_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerPlantBlock(this.name, (class_2248)new LargeFlowerBlock(this.statusEffect, 7, class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9634().method_9618().method_9626(class_2498.field_11535).method_49229(class_4970.class_2250.field_10657).method_50012(class_3619.field_15971)), (class_1935)this.itemBefore, 0.4f);
        } else if (this.preset == FlowerPreset.SMALL) {
            this.flowerBlock = NSRegistryHelper.registerPlantBlock(this.name, (class_2248)new class_2356(this.statusEffect, 7, class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9634().method_9618().method_9626(class_2498.field_11535).method_49229(class_4970.class_2250.field_10657).method_50012(class_3619.field_15971)), (class_1935)this.itemBefore, 0.3f);
        } else if (this.preset == FlowerPreset.MID_SMALL) {
            this.flowerBlock = NSRegistryHelper.registerPlantBlock(this.name, (class_2248)new MidFlowerBlock(this.statusEffect, 7, class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9634().method_9618().method_9626(class_2498.field_11535).method_49229(class_4970.class_2250.field_10657).method_50012(class_3619.field_15971)), (class_1935)this.itemBefore, 0.3f);
        }
        if (this.hasFlowerPot()) {
            this.pottedFlowerBlock = NSRegistryHelper.registerTransparentBlockWithoutTab("potted_" + this.name, (class_2248)new class_2362(this.flowerBlock, class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971)));
            this.registeredBlocksList.add(this.pottedFlowerBlock);
        }
        this.registeredBlocksList.add(this.flowerBlock);
        NSRegistryHelper.FlowerHashMap.put(this.name, this);
    }

    public int getDyeNumber() {
        switch (this.preset.ordinal()) {
            case 2: 
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    public List<class_2248> getRegisteredBlocksList() {
        return this.registeredBlocksList;
    }

    public List<class_1792> getRegisteredItemsList() {
        return this.registeredItemsList;
    }

    public FlowerPreset getPreset() {
        return this.preset;
    }

    public boolean hasFlowerPot() {
        return this.getPreset() == FlowerPreset.SMALL || this.getPreset() == FlowerPreset.BIG_SMALL || this.getPreset() == FlowerPreset.MID_SMALL;
    }

    public boolean isTall() {
        return this.getPreset() == FlowerPreset.TALL || this.getPreset() == FlowerPreset.BIG_TALL;
    }

    public class_1792 getDyeColor() {
        return this.dyeColor;
    }

    public class_2248 getFlowerBlock() {
        return this.flowerBlock;
    }

    public class_2248 getPottedFlowerBlock() {
        return this.pottedFlowerBlock;
    }

    public String getName() {
        return this.name;
    }

    public static enum FlowerPreset {
        SMALL,
        MID_SMALL,
        TALL,
        BIG_SMALL,
        BIG_TALL;

    }
}

